varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D 	vignette;
uniform vec3		colorize;
uniform float		saturate,
					vignetteLum;
uniform vec2		ofs;
uniform vec3		contrast,
					brightness;

uniform sampler2D	ramp;

vec3			one=vec3(1.0,1.0,1.0);
vec3			hlf=vec3(0.5,0.5,0.5);

vec3 			rmul,
				rscr;
vec4 			color;
float			lum;
float			OneMinusSat,
				lumsat;

uniform sampler2D	vel;

void main()
{
	
	//color=;

	// chromatic aberration
	color.x = tex2D(tex, texcoord.xy-vec2(ofs.x,0.0)).x;//( (texcoord.xy)-0.5 ) * (1.0 - 0.005) + 0.5).x;      
	color.y = tex2D(tex, texcoord.xy+vec2(0.0,ofs.y)).y;//( (texcoord.xy)-0.5 ) * (1.0 - 0.01) + 0.5).y;      
	color.z = tex2D(tex, texcoord.xy+vec2(ofs.x,0.0)).z;//( (texcoord.xy)-0.5 ) * (1.0 - 0.05) + 0.5).z;    

	// vignette
	vec4 vignetteColor=texture2D(vignette, texcoord);
	color=mix(color,vignetteColor,clamp(vignetteLum,0.0,1.0)*(1.0-vignetteColor.a));
	
	// sharpening /////////////////////////
	vec4 sharpened=color*5.0;//11.0/3.0;
	sharpened-=tex2D(tex, texcoord.xy-vec2(0.0,ofs.y));//*2.0/3.0;
	sharpened-=tex2D(tex, texcoord.xy+vec2(0.0,ofs.y));//*2.0/3.0;
	sharpened-=tex2D(tex, texcoord.xy-vec2(ofs.x,0.0));//*2.0/3.0;
	sharpened-=tex2D(tex, texcoord.xy+vec2(ofs.x,0.0));//*2.0/3.0;
	color=mix(color,sharpened,0.5);
	
	// MOTION BLUR	//////////////////////////////////
	vec3 v=texture2D(vel, texcoord).rgb;
	v.z+=0.1;
	float count=1.0;
	float dd=0.0;

	// Sample the color buffer along the velocity vector.
	vec4 currentColor = texture2D(tex, texcoord+v.xy*1.5);
	float d2=-texture2D(vel, texcoord+v.xy*1.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*1.5);
	d2=-texture2D(vel, texcoord-v.xy*1.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*3.0);
	d2=-texture2D(vel, texcoord+v.xy*3.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*3.0);
	d2=-texture2D(vel, texcoord-v.xy*3.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*4.5);
	d2=-texture2D(vel, texcoord+v.xy*4.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*4.5);
	d2=-texture2D(vel, texcoord-v.xy*4.5).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*6.0);
	d2=-texture2D(vel, texcoord+v.xy*6.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*6.0);
	d2=-texture2D(vel, texcoord-v.xy*6.0).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	/////////////////////////////////////////////////////////

	currentColor = texture2D(tex, texcoord+v.xy*0.75);
	d2=-texture2D(vel, texcoord+v.xy*0.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*0.75);
	d2=-texture2D(vel, texcoord-v.xy*0.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*2.25);
	d2=-texture2D(vel, texcoord+v.xy*2.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*2.25);
	d2=-texture2D(vel, texcoord-v.xy*2.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*3.75);
	d2=-texture2D(vel, texcoord+v.xy*3.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*3.75);
	d2=-texture2D(vel, texcoord-v.xy*3.75).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord+v.xy*5.25);
	d2=-texture2D(vel, texcoord+v.xy*5.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	currentColor = texture2D(tex, texcoord-v.xy*5.25);
	d2=-texture2D(vel, texcoord-v.xy*5.25).z;
	dd=clamp((d2+v.z),0.0,1.0);
	color+=currentColor*dd;
	count+=dd;

	//////////////////////////////////////////////////
	
	color/=count;

	// BRIGHTNESS & CONTRAST
	color.xyz = ((color.xyz-hlf)*contrast) + hlf + brightness;
	
	rmul=color.xyz*colorize;
	rscr=one-((one-colorize)*(one-color.xyz));
	color.xyz=color.xyz*rscr+(one-color.xyz)*rmul;

	//desaturate	/////////////////////////////////
	lum=dot(color.rgb,vec3(0.3,0.59,0.11));
	OneMinusSat=saturate;
	lumsat=lum*(1.0-saturate);
	color.r=lumsat+color.r*OneMinusSat;
	color.g=lumsat+color.g*OneMinusSat;
	color.b=lumsat+color.b*OneMinusSat;
	
	// COLOR CORRECTION	/////////////////////////
	color.r = texture2D(ramp, vec2(color.r,0.5) ).r;
	color.g = texture2D(ramp, vec2(color.g,0.5) ).g;
	color.b = texture2D(ramp, vec2(color.b,0.5) ).b;
	
	gl_FragColor.xyz = color;
}
